<?php

use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;


$app->get('/{activity_type}/getactivities', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

   $activity_type = addslashes(strip_tags(trim($args['activity_type'])));

    $data = $entityManager->getRepository('Activity')->getActivities($activity_type);

    return $response->withJson($data, 200);
});

$app->post('/{apikey}/addactivity', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

        $body = $request->getParsedBody();

        $this->logger->addInfo("Activity Submission by : " . $body['email']);


        $data = $entityManager->getRepository('Activity')->addActivity($body);

        return $response->withJson($data, 200);

});

$app->get('/{username}/{activity_type}/getmyactivity', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

   $activity_type = addslashes(strip_tags(trim($args['activity_type'])));
   $username = addslashes(strip_tags(trim($args['username'])));

    $data = $entityManager->getRepository('Activity')->getMyActivity($username,$activity_type);

    return $response->withJson($data, 200);
});
