<?php

use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;

//otp for admission
$app->post('/admissionotp', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();
    $this->logger->addInfo("Otp Generation By : " . $body['phone']);

    $data = $entityManager->getRepository('AdmissionOtp')->addOtp($body);

    return $response->withJson($data, 200);
});

$app->post('/resendotp', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();
    $this->logger->addInfo("Otp Generation By : " . $body['phone']);

    $data = $entityManager->getRepository('AdmissionOtp')->resendOtp($body);

    return $response->withJson($data, 200);
});

$app->post('/admissiontemp/signup', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    $data = $entityManager->getRepository('AdmissionTemp')->addGeneralUser($body);

    return $response->withJson($data, 200);
});

$app->post('/admissiontemp/login', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    $headers = $request->getHeaders();
    $unit = $headers['HTTP_UNIT'];

    $this->logger->addInfo("General Login :" . $unit[0] . " call: " . $body['email']);

    $data = $entityManager->getRepository('AdmissionTemp')->login($unit[0], $body);

    $this->logger->addInfo("General Login :" . $unit[0] . " call: " . $body['email'] . " successfull");

    return $response->withJson($data, 200);
});

$app->get('/{email}/admissiontemp/getstudentsingle', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $email = addslashes(strip_tags(trim($args['email'])));

    $data = $entityManager->getRepository('AdmissionTemp')->getGeneralUserSingle($email);

    return $response->withJson($data, 200);
});

$app->post('/{step}/admissionform/addstudent', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    $step = addslashes(strip_tags(trim($args['step'])));

    $data = $entityManager->getRepository('AdmissionForm')->addStudent($body, $step);

    return $response->withJson($data, 200);
});


$app->post('/admissionform/paymentdoing', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    

    $data = $entityManager->getRepository('AdmissionForm')->paymentDoing($body);

    return $response->withJson($data, 200);
});

$app->post('/admissionform/addfinalmajor', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    $data = $entityManager->getRepository('AdmissionForm')->addFinalMajor($body);

    return $response->withJson($data, 200);
});

$app->put('/{id}/{step}/admissionform/updatestudent', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    $step = addslashes(strip_tags(trim($args['step'])));
    $id = addslashes(strip_tags(trim($args['id'])));

    $data = $entityManager->getRepository('AdmissionForm')->updateStudent($id, $step, $body);

    return $response->withJson($data, 200);
});

$app->get('/{email}/{course}/admissionform/getactivestudentsingle', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $course = addslashes(strip_tags(trim($args['course'])));
    $email = addslashes(strip_tags(trim($args['email'])));

    $data = $entityManager->getRepository('AdmissionForm')->getActiveStudentSingle($email,$course);

    return $response->withJson($data, 200);
});

$app->get('/admissionform/count', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $data = $entityManager->getRepository('AdmissionForm')->getAdmissionCount();

    return $response->withJson($data, 200);
});

$app->get('/admissionform/count-re', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $data = $entityManager->getRepository('AdmissionForm')->getAdmissionCountRe();

    return $response->withJson($data, 200);
});

$app->post('/admissionform/getactivestudentsinglebyformid', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    $form_id = addslashes(strip_tags(trim($body['form_id'])));

    $data = $entityManager->getRepository('AdmissionForm')->getActiveStudentSingleByFormId($form_id);

    return $response->withJson($data, 200);
});

$app->post('/admissionform/getfilesofactivestudentsingle', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    $form_id = addslashes(strip_tags(trim($body['form_id'])));

    $data = $entityManager->getRepository('AdmissionForm')->getFilesOfActiveStudentSingleByFormId($form_id);

    return $response->withJson($data, 200);
});

$app->post('/admissionform/getfilesofactivestudentsinglenew', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    $form_id = addslashes(strip_tags(trim($body['form_id'])));

    $data = $entityManager->getRepository('AdmissionForm')->getFilesOfActiveStudentSingleByFormIdNew($form_id);

    return $response->withJson($data, 200);
});

$app->post('/admissionform/adminedit', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    $data = $entityManager->getRepository('AdmissionForm')->setNewAdminData($body);

    return $response->withJson($data, 200);
});

$app->get('/admissionform/getactivestudent', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $data = $entityManager->getRepository('AdmissionForm')->getActiveStudent();

    return $response->withJson($data, 200);
});

$app->post('/{email}/admissionform/seatallocation', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';
    $email = addslashes(strip_tags(trim($args['email'])));
    $body = $request->getParsedBody();
    $data = $entityManager->getRepository('SeatAllocation')->allocateSeat($email, $body);

    return $response->withJson($data, 200);
});

$app->get('/{email}/admissionform/gotopayment', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';
    $email = addslashes(strip_tags(trim($args['email'])));

    // we will check for self financing course
    $st = $entityManager->getRepository('AdmissionForm')->checkStudent($email);

    $b = [];


    if ($st[0]->getCourse() === 'HS') {
        $data = $entityManager->getRepository('AdmissionForm')->gotToStep($email, 5);
        $data1 = $entityManager->getRepository('AdmissionForm')->completeThisApplication($email);
        $b['step'] = $data;
        $b['complete'] = $data1;
    }
    if ($st[0]->getCourse() === 'TDC') {

        // if ($st[0]->getStream() === 'COMMERCE') {
        //     // payment needed
        //     $data = $entityManager->getRepository('AdmissionForm')->gotToStep($email, 4);
        //     $b['step'] = $data;
        //     $b['complete'] = false;
        // } else {
        $data = $entityManager->getRepository('AdmissionForm')->gotToStep($email, 5);
        $data1 = $entityManager->getRepository('AdmissionForm')->completeThisApplication($email);
        $b['step'] = $data;
        $b['complete'] = $data1;
    }

    if ($st[0]->getCourse() === 'BCA') {

        // if ($st[0]->getStream() === 'COMMERCE') {
        //     // payment needed
        //     $data = $entityManager->getRepository('AdmissionForm')->gotToStep($email, 4);
        //     $b['step'] = $data;
        //     $b['complete'] = false;
        // } else {
        $data = $entityManager->getRepository('AdmissionForm')->gotToStep($email, 5);
        $data1 = $entityManager->getRepository('AdmissionForm')->completeThisApplication($email);
        $b['step'] = $data;
        $b['complete'] = $data1;
    }

    if ($st[0]->getCourse() === 'BSC-BIOTECHNOLOGY') {

        // if ($st[0]->getStream() === 'COMMERCE') {
        //     // payment needed
        //     $data = $entityManager->getRepository('AdmissionForm')->gotToStep($email, 4);
        //     $b['step'] = $data;
        //     $b['complete'] = false;
        // } else {
        $data = $entityManager->getRepository('AdmissionForm')->gotToStep($email, 5);
        $data1 = $entityManager->getRepository('AdmissionForm')->completeThisApplication($email);
        $b['step'] = $data;
        $b['complete'] = $data1;
    }


    if ($st[0]->getCourse() === 'PG') {

        
            // payment needed
            $data = $entityManager->getRepository('AdmissionForm')->gotToStep($email, 4);
            $b['step'] = $data;
            $b['complete'] = false;
        
        // $data = $entityManager->getRepository('AdmissionForm')->gotToStep($email, 5);
        // $data1 = $entityManager->getRepository('AdmissionForm')->completeThisApplication($email);
        // $b['step'] = $data;
        // $b['complete'] = $data1;
    
    }

    return $response->withJson($b, 200);
});

$app->get('/{email}/admissionform/haspaymentdone', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';
    $email = addslashes(strip_tags(trim($args['email'])));

    $data = $entityManager->getRepository('AdmissionForm')->hasPaymentDone($email);

    return $response->withJson($data, 200);
});

$app->get('/getpaymentreceipt', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $au = new Authentication();
    $email = $au->getUsername($request);
    $data = $entityManager->getRepository('AdmissionForm')->getPaymentResponse($email);

    return $response->withJson($data, 200);
});

$app->post('/{email}/admissionform/updateseat', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';
    $email = addslashes(strip_tags(trim($args['email'])));
    $body = $request->getParsedBody();
    $data = $entityManager->getRepository('SeatAllocation')->updateSeat($email, $body);

    return $response->withJson($data, 200);
});

$app->get('/admissionform/getreportinitials', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();
    $data = $entityManager->getRepository('AdmissionForm')->getReportsInitial();

    return $response->withJson($data, 200);
});

$app->post('/admissionform/meritlist', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();
    $data = $entityManager->getRepository('AdmissionForm')->getMeritList($body);

    return $response->withJson($data, 200);
});

$app->post('/admissionform/studentlist', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();
    $data = $entityManager->getRepository('AdmissionForm')->getAdmissionList($body);

    return $response->withJson($data, 200);
});

$app->post('/admissionform/meritlistshort', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();
    $data = $entityManager->getRepository('AdmissionForm')->getMeritListShort($body);

    return $response->withJson($data, 200);
});

$app->post('/admissionform/meritlistmajor', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();
    $data = $entityManager->getRepository('AdmissionForm')->getMeritListMajor($body);

    return $response->withJson($data, 200);
});

$app->post('/admission/getadmittedstudents', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();
    //$data = $entityManager->getRepository('Student')->getNewlyAdmittedStudents($body);
    $data = $entityManager->getRepository('Student')->getJustAdmittedStudents($body);

    return $response->withJson($data, 200);
});

$app->post('/forgotpassworda', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';
    require_once __DIR__ . '/../models/GeneralUser.php';

    $body = $request->getParsedBody();
    $email = addslashes(strip_tags(trim($body['email'])));
    $course = addslashes(strip_tags(trim($body['course'])));
    $data = '';
    $a = $entityManager->getRepository('AdmissionTemp')->checkEmail($email,$course);
    if (sizeof($a) > 0) {
        $body['phone'] = $a[0]->getPhone();
        $data = $entityManager->getRepository('AdmissionTemp')->forgotPassword($body);
    } else {
        $b = $entityManager->getRepository('Student')->checkEmail($email);
        if (sizeof($b) > 0) {
            $body['phone'] = $b[0]->getPhone();
            $data = $entityManager->getRepository('GeneralUser')->forgotPassword($body);
        }
    }

    return $response->withJson($data, 200);
});

$app->post('/forgotpassworda/otp', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';
    require_once __DIR__ . '/../models/GeneralUser.php';

    $body = $request->getParsedBody();
    $course = addslashes(strip_tags(trim($body['course'])));
    $email = addslashes(strip_tags(trim($body['email'])));

    $a = $entityManager->getRepository('AdmissionTemp')->checkEmail($email,$course);
    if (sizeof($a) > 0) {
        $body['phone'] = $a[0]->getPhone();
        $data = $entityManager->getRepository('AdmissionTemp')->forgotPasswordOtp($body);
    } else {
        $b = $entityManager->getRepository('Student')->checkEmail($email);
        if (sizeof($b) > 0) {
            $body['phone'] = $b[0]->getPhone();
            $data = $entityManager->getRepository('GeneralUser')->forgotPasswordOtp($body);
        }
    }

    return $response->withJson($data, 200);
});

$app->post('/forgotpassworda/final', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';
    require_once __DIR__ . '/../models/GeneralUser.php';

    $body = $request->getParsedBody();

    $this->logger->addInfo("Password changed: " . $body['email']);
    $course = addslashes(strip_tags(trim($body['course'])));
    $email = addslashes(strip_tags(trim($body['email'])));
    $a = $entityManager->getRepository('AdmissionTemp')->checkEmail($email,$course);

    if (sizeof($a) > 0) {
        $body['phone'] = $a[0]->getPhone();
        $data = $entityManager->getRepository('AdmissionTemp')->forgotPasswordFinal($body);
    } else {
        $b = $entityManager->getRepository('Student')->checkEmail($body['email']);
        if (sizeof($b) > 0) {
            $body['phone'] = $b[0]->getPhone();
            $data = $entityManager->getRepository('GeneralUser')->forgotPasswordFinal($body);
        }
    }
    return $response->withJson($data, 200);
});

//payment master

$app->post('/admission/addpaymentsmaster', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    $data = $entityManager->getRepository('PaymentsMaster')->addPaymentsMaster($body);

    return $response->withJson($data, 200);
});

$app->get('/admission/getpaymentsmaster', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    $data = $entityManager->getRepository('PaymentsMaster')->getPaymentsMaster($body);

    return $response->withJson($data, 200);
});

$app->post('/admission/getpaymentsmasterbycourse', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    $data = $entityManager->getRepository('PaymentsMaster')->getPaymentsForAdmission($body);

    return $response->withJson($data, 200);
});

$app->put('/{id}/admission/updatepaymentsmaster', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();
    $id = addslashes(strip_tags(trim($args['id'])));

    $data = $entityManager->getRepository('PaymentsMaster')->updatePaymentsMaster($body, $id);

    return $response->withJson($data, 200);
});

$app->delete('/{id}/admission/deletepaymentsmaster', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $id = addslashes(strip_tags(trim($args['id'])));

    $data = $entityManager->getRepository('PaymentsMaster')->deletePaymentsMaster($id);

    return $response->withJson($data, 200);
});

//payment receipt

$app->get('/{form_id}/admission/getpaymentcondition', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $form_id = addslashes(strip_tags(trim($args['form_id'])));

    $student = $entityManager->getRepository('Student')->getStudentObjectByFormId($form_id);

    $dept_code = $student[0]->getDeptCode();
    /* if ($dept_code == 'BIOT') {
    $course = 'BSC-BIOTECHNOLOGY';
    $stream = '';
    $course_type = '';
    $semester = $student[0]->getSemester();
    } else if ($dept_code == 'BCA') {
    $course = 'BCA';
    $stream = '';
    $semester = $student[0]->getSemester();
    } else {
    $course = $student[0]->getCourse();
    $stream = $student[0]->getStream();
    $course_type = $student[0]->getCourseType();
    $semester = $student[0]->getSemester();
    } */

    $course = $student[0]->getCourse();
    $stream = $student[0]->getStream();
    $course_type = $student[0]->getCourseType();
    $semester = $student[0]->getSemester();

    $gender = $student[0]->getGender();
    $is_free_admission = $student[0]->getIsFreeAdmission();

    //return array

    $a = [];
    $a['course'] = $course;
    $a['stream'] = $stream;
    $a['course_type'] = $course_type;
    $a['is_girl'] = 0;
    $a['has_icsc'] = 0;
    $a['has_geo'] = 0;
    $a['has_biotech'] = 0;
    $a['has_geo_hn'] = 0;
    $a['final_payment'] = 0;
    $a['narration'] = '';
    $a['is_free_admission'] = $is_free_admission;
    $is_biotech = 0;
    $addOn = [];

    // let's get the payments master
    

    $payments = $entityManager->getRepository('PaymentsMaster')->getPaymentsForAdmission(array("course"=>$course,"semester"=>$semester,"course_type"=>$course_type,"gender"=>$gender));

    if (sizeof($student) > 0) {
        $student_id = $student[0]->getId();

        $subjects = $entityManager->getRepository('Student')->getStudentSubjectById($student_id);

        // now check whether subjects are available or not

        /*
        Assamese PG =  12,000.00
        Ecomonics PG = 16,000.00
        Education PG = 18,000.00
        Zoology PG = 22,000.00
        Geography PG = 22,000.00
         */

        if (sizeof($subjects) > 0) {
            foreach ($subjects as $sb) {
                if ($sb['value'] === 'ICSC') {
                    $a['has_icsc'] = 1;

                    $c = new \stdClass;
                    $c->sm_head = "ICSC Subject (Self-financing)";
                    $c->sm_amount = "3000";
                    array_push($addOn, $c);
                }

                if ($sb['value'] === 'GEO101' && $student[0]->getStream() === 'ARTS') {
                    $a['has_geo'] = 1;

                    $c = new \stdClass;
                    $c->sm_head = "Geography Subject";
                    $c->sm_amount = "700";
                    array_push($addOn, $c);
                }

                if ($sb['value'] === 'BIOTECH(G)') {
                    $a['has_biotech'] = 1;

                    $c = new \stdClass;
                    $c->sm_head = "Biotechnology Subject (General)";
                    $c->sm_amount = "6000";

                    array_push($addOn, $c);
                }

                if ($sb['value'] === 'BIOTECH(M)') {
                    $a['has_biotech'] = 1;

                    $c = new \stdClass;
                    $c->sm_head = "Biotechnology Subject (General)";
                    $c->sm_amount = "22000";

                    array_push($addOn, $c);
                    if ($semester != '1') {
                        $is_biotech = 1;
                    }
                }

                if ($sb['value'] === 'GEO(M)' && $student[0]->getStream() === 'ARTS') {
                    $a['has_geo_hn'] = 1;

                    $c = new \stdClass;
                    $c->sm_head = "Laboratory fee for Geography";
                    $c->sm_amount = "800";
                    array_push($addOn, $c);
                }

                if ($sb['value'] === 'GEO(G)' && $student[0]->getStream() === 'ARTS') {
                    $a['has_geo_hn'] = 1;

                    $c = new \stdClass;
                    $c->sm_head = "Laboratory fee for Geography";
                    $c->sm_amount = "800";
                    array_push($addOn, $c);
                }

                if ($sb['value'] === 'CSA(M)') {
                    $a['hs_csa_maj'] = 1;

                    $c = new \stdClass;
                    $c->sm_head = "Computer Science Major Fees";
                    $c->sm_amount = "8000";
                    array_push($addOn, $c);
                }

                if ($sb['value'] === 'CSA(G)') {
                    $a['hs_csa_maj'] = 1;

                    $c = new \stdClass;
                    $c->sm_head = "Computer Science General Fees";
                    $c->sm_amount = "6000";
                    array_push($addOn, $c);
                }

                if ($sb['value'] == 'MASS(PG)' && $semester == 1) {
                    $a['pg'] = 1;
                    $c = new \stdClass;
                    $c->sm_head = "Admission Fees";
                    $c->sm_amount = "12000.00";
                    array_push($addOn, $c);
                }

                if ($sb['value'] == 'MASS(PG)' && $semester != 1) {
                    $a['pg'] = 1;
                    $c = new \stdClass;
                    $c->sm_head = "Admission Fees";
                    $c->sm_amount = "12000.00";
                    array_push($addOn, $c);
                }

                if ($sb['value'] == 'BEN(PG)' && $semester == 1) {
                    $a['pg'] = 1;
                    $c = new \stdClass;
                    $c->sm_head = "Admission Fees";
                    $c->sm_amount = "12000.00";
                    array_push($addOn, $c);
                }

                if ($sb['value'] == 'BEN(PG)' && $semester != 1) {
                    $a['pg'] = 1;
                    $c = new \stdClass;
                    $c->sm_head = "Admission Fees";
                    $c->sm_amount = "12000.00";
                    array_push($addOn, $c);
                }

                if ($sb['value'] == 'ECO' && $semester == 1) {
                    $a['pg'] = 1;
                    $c = new \stdClass;
                    $c->sm_head = "Admission Fees";
                    $c->sm_amount = "16000.00";
                    array_push($addOn, $c);
                }

                if ($sb['value'] == 'ECO' && $semester != 1) {
                    $a['pg'] = 1;
                    $c = new \stdClass;
                    $c->sm_head = "Admission Fees";
                    $c->sm_amount = "12000.00";
                    array_push($addOn, $c);
                }

                if ($sb['value'] == 'EDU(PG)' && $semester == 1) {
                    $a['pg'] = 1;
                    $c = new \stdClass;
                    $c->sm_head = "Admission Fees";
                    $c->sm_amount = "18000.00";
                    array_push($addOn, $c);
                }

                if ($sb['value'] == 'EDU(PG)' && $semester != 1) {
                    $a['pg'] = 1;
                    $c = new \stdClass;
                    $c->sm_head = "Admission Fees";
                    $c->sm_amount = "16000.00";
                    array_push($addOn, $c);
                }

                if ($sb['value'] == 'GEO(PG)' && $semester == 1) {
                    $a['pg'] = 1;
                    $c = new \stdClass;
                    $c->sm_head = "Admission Fees";
                    $c->sm_amount = "22000.00";
                    array_push($addOn, $c);
                }

                if ($sb['value'] == 'GEO(PG)' && $semester != 1) {
                    $a['pg'] = 1;
                    $c = new \stdClass;
                    $c->sm_head = "Admission Fees";
                    $c->sm_amount = "20000.00";
                    array_push($addOn, $c);
                }

                if ($sb['value'] == 'ZOO(PG)' && $semester == 1) {
                    $a['pg'] = 1;
                    $c = new \stdClass;
                    $c->sm_head = "Admission Fees";
                    $c->sm_amount = "22000.00";
                    array_push($addOn, $c);
                }

                if ($sb['value'] == 'ZOO(PG)' && $semester != 1) {
                    $a['pg'] = 1;
                    $c = new \stdClass;
                    $c->sm_head = "Admission Fees";
                    $c->sm_amount = "20000.00";
                    array_push($addOn, $c);
                }

                if ($sb['value'] == 'BIOTECH(PG)') {
                    $a['pg'] = 1;
                    $c = new \stdClass;
                    $c->sm_head = "Admission Fees";
                    $c->sm_amount = "30000.00";
                    array_push($addOn, $c);
                }
            }
        }

        //get gender

        if ($gender === 'MALE') {
            $a['is_girl'] = 0;
        } else if ($gender === 'FEMALE') {
            $a['is_girl'] = 1;
        }

        if ($is_free_admission != '1') {
            $a['add_on'] = $addOn;
        }
    }

    $final_result = [];

    if (is_array($payments) && sizeof($payments) > 0) {
        // add add on with original payment table

        $p = $payments[0]['payment_table'];
        if ($is_biotech != 1) {
            $q = array_merge($p, $addOn);
            $payments[0]['payment_table'] = $q;
        } else {
            $payments[0]['payment_table'] = $addOn;
            $payments[0]['payment_amount'] = 0;
        }
    } else {
        $payments[0]['payment_table'] = $addOn;
        $payments[0]['payment_amount'] = 0;
    }

    if ($is_biotech == 1) {
        $payments[0]['payment_table'] = $addOn;
        $payments[0]['payment_amount'] = 0;
    }
    //get total from $addOn

    $add_total = 0;

    foreach ($addOn as $ao) {
        $add_total = $add_total + (float) $ao->sm_amount;
    }

    if ($is_free_admission === 0) {
        $payments[0]['payment_amount'] = (float) $payments[0]['payment_amount'] + $add_total;
    } else if ($is_free_admission === 1) {
        $payments[0]['payment_amount'] = 0;
        $a['narration'] = '(Free Admission vide DHE/PEN/Misc/171/2019/36)';
    }

    $a['final_payment'] = $payments[0];

    return $response->withJson($a, 200);
});

$app->post('/admission/addpaymentreceipt', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    $data = $entityManager->getRepository('AdmissionReceipt')->addAdmissionReceipt($body);

    return $response->withJson($data, 200);
});

$app->post('/admission/receiptreport', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();
    $starting_date = addslashes(strip_tags(trim($body['starting_date'])));
    $ending_date = addslashes(strip_tags(trim($body['ending_date'])));

    $need_csv = 0;
    if (array_key_exists('need_csv', $body)) {
        $need_csv = $body['need_csv'];
    }

    if ($need_csv == 0) {
        $data = $entityManager->getRepository('AdmissionReceipt')->getReceiptReport($starting_date, $ending_date);
        return $response->withJson($data, 200);
    } else {
        $data = $entityManager->getRepository('AdmissionReceipt')->getReceiptReport($starting_date, $ending_date);

        if (sizeof($data) > 0) {
            $firstRow = array_keys($data[0]);

            $output = fopen('php://memory', 'w');
            fputcsv($output, $firstRow);

            foreach ($data as $d) {
                fputcsv($output, $d);
            }
            $stream = new \Slim\Http\Stream($output);

            return $response->withHeader('Content-Type', 'application/force-download')
                ->withHeader('Content-Type', 'application/octet-stream')
                ->withHeader('Content-Type', 'application/download')
                ->withHeader('Content-Description', 'File Transfer')
                ->withHeader('Content-Transfer-Encoding', 'binary')
                ->withHeader('Content-Disposition', 'attachment; filename="data.csv"')
                ->withHeader('Expires', '0')
                ->withHeader('Cache-Control', 'must-revalidate, post-check=0, pre-check=0')
                ->withHeader('Pragma', 'public')
                ->withBody($stream);
        }
    }
});

$app->post('/admission/getreceiptsbyreceiptno', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    $receipt_no = addslashes(strip_tags(trim($body['receipt_no'])));

    $data = $entityManager->getRepository('AdmissionReceipt')->getReceiptByReceiptNo($receipt_no);

    return $response->withJson($data, 200);
});

$app->post('/admission/getreceiptsformno', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    $form_id = addslashes(strip_tags(trim($body['form_id'])));

    $data = $entityManager->getRepository('AdmissionReceipt')->getReceiptsFormNo($form_id);

    return $response->withJson($data, 200);
});

$app->post('/admission/idcards', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    $id = addslashes(strip_tags(trim($body['id'])));

    $data = $entityManager->getRepository('Student')->getStudentById($id);

    return $response->withJson($data, 200);
});

$app->post('/admission/getreceiptsbyformid', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    $form_id = addslashes(strip_tags(trim($body['form_id'])));

    $data = $entityManager->getRepository('AdmissionReceipt')->getReceiptByFormId($form_id);

    return $response->withJson($data, 200);
});

$app->get('/admission/getreceipts', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $data = $entityManager->getRepository('AdmissionReceipt')->getReceipts();

    return $response->withJson($data, 200);
});

$app->post('/admissionform/getlistforverification', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();
    $data = $entityManager->getRepository('AdmissionForm')->getListForVerification($body);

    return $response->withJson($data, 200);
});

$app->post('/admissionform/getformforprint', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    $form_id = addslashes(strip_tags(trim($body['form_id'])));

    $data = $entityManager->getRepository('AdmissionForm')->getActiveStudentSingleByFormId($form_id);

    return $response->withJson($data, 200);
});

$app->post('/{apikey}/admissionform/admin-verification', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    if (getenv('FACULTY_API_KEY') == $args['apikey']) {
        require_once __DIR__ . '/../functions/auth.php';
        $auth = new Authentication;
        $teacher_email = $auth->getUsername($request);
        $r = $entityManager->getRepository('Employee')->getEmployeeForEdit($teacher_email);
        if(sizeof($r) > 0){
        $teacher_name = $r[0]->getName();
        $body = $request->getParsedBody();

        $data = $entityManager->getRepository('AdmissionForm')->updateVerificationStatus($body, $teacher_name);

        return $response->withJson($data, 200);
    }else{
        return $response->withStatus(401);
    }
    }else{
        return $response->withStatus(401);
    }
});

$app->post('/{apikey}/admissionform/admin-verification-set-fee', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

   
    if (getenv('FACULTY_API_KEY') == $args['apikey']){

        $body = $request->getParsedBody();

        $form_id = addslashes(strip_tags(trim($body['form_id'])));
        $is_free_admission = addslashes(strip_tags(trim($body['is_free_admission'])));
        $payment_mode = addslashes(strip_tags(trim($body['payment_mode'])));
        $transaction_id = addslashes(strip_tags(trim($body['transaction_id'])));
        $fee_group_id = addslashes(strip_tags(trim($body['fee_group_id'])));

        $data = $entityManager->getRepository('AdmissionForm')->updateVerificationStatusWithFee($form_id, $is_free_admission, $fee_group_id, $payment_mode, $transaction_id);

        return $response->withJson($data, 200);
    } else {
        return $response->withStatus(401);
    }
});

$app->post('/admissionform/updatebasicdetailsonverification', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    $data = $entityManager->getRepository('AdmissionForm')->updateBasicDetailsOnVerification($body);

    return $response->withJson($data, 200);
});


$app->post('/admissionform/updatesubjectdetailsonverification', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    $form_id = addslashes(strip_tags(trim($body['form_id'])));
    $course = addslashes(strip_tags(trim($body['course'])));
    $stream = addslashes(strip_tags(trim($body['stream'])));
    $compulsory_1 = $body['compulsory_1'];


    $data = $entityManager->getRepository('AdmissionForm')->updateSubjectDetailssOnVerification($form_id, $course, $stream,$compulsory_1);

    return $response->withJson($data, 200);
});

$app->post('/admissionform/getlistforsendingrequest', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();
    $data = $entityManager->getRepository('AdmissionForm')->getListForSendingRequests($body);

    return $response->withJson($data, 200);
});

$app->post('/{apikey}/getadmittedlist', function (Request $request, Response $response, $args) {
    require __DIR__ . '/../../bootstrap.php';
    
    if (getenv('FACULTY_API_KEY') == $args['apikey']) {

        $body = $request->getParsedBody();
        $course = addslashes(strip_tags(trim($body['course'])));
        $stream = addslashes(strip_tags(trim($body['stream'])));

        $data = $entityManager->getRepository('AdmissionForm')->fecthAdmittedListThisSession($course,$stream);

        return $response->withJson($data, 200);
    }else{
        return $response->withStatus(401);
    }
});
