<?php
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;

$app->get('/getallowadmission', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $data = $entityManager->getRepository('AllowAdmission')->getAll();

    return $response->withJson($data, 200);
});

$app->get('/getactiveadmission', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $data = $entityManager->getRepository('AllowAdmission')->getActiveAdmission();

    return $response->withJson($data, 200);
});



$app->get('/getallowadmissionbytype/{type}', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';


    $type = addslashes(strip_tags(trim($args['type'])));

    $data = $entityManager->getRepository('AllowAdmission')->getAllByType($type);

    return $response->withJson($data, 200);
});

$app->post('/{apikey}/addallowadmission', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    
    $data = $entityManager->getRepository('AllowAdmission')->add($body);

    return $response->withJson($data, 200);
});

$app->put('/{apikey}/{id}/updateallowadmission', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();



    $id = addslashes(strip_tags(trim($args['id'])));

    $data = $entityManager->getRepository('AllowAdmission')->update($id, $body);

    return $response->withJson($data, 200);
});


$app->delete('/{apikey}/{id}/deleteallowadmission', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $id = addslashes(strip_tags(trim($args['id'])));




    $data = $entityManager->getRepository('AllowAdmission')->delete($id);

    return $response->withJson($data, 200);
});



