<?php

use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;


$app->get('/{id}/getmyassignments', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

   $id = addslashes(strip_tags(trim($args['id'])));

    $student = $entityManager->getRepository('Student')->getStudentByIdNew($id);

    

    $data = $entityManager->getRepository('Assignment')->getMyAssignments($student, $id);

    return $response->withJson($data, 200);
});


$app->get('/{id}/{assignment_id}/getsingleassignmentdata', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $id = addslashes(strip_tags(trim($args['id'])));

    $assignment_id = addslashes(strip_tags(trim($args['assignment_id'])));


    $data = $entityManager->getRepository('Assignment')->singleAssignment($assignment_id, $id);

    return $response->withJson($data, 200);
});


$app->post('/{id}/submitmyassignment', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $id = addslashes(strip_tags(trim($args['id'])));

    $body = $request->getParsedBody();
    $assignment_id = addslashes(strip_tags(trim($body['assignment_id'])));

    $d = $entityManager->getRepository('Assignment')->singleAssignment($assignment_id, $id);
    if ($d['status'] == true) {
        $data = $entityManager->getRepository('AssignmentSubmission')->submitAssignment($id, $body);
    } else {
        $data = $d;
    }

    return $response->withJson($data, 200);
});
