<?php
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;



$app->get('/{apikey}/{username}/getstudentreportsinglesubjectwise', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $apikey = addslashes(strip_tags(trim($args['apikey'])));
    $email = addslashes(strip_tags(trim($args['username'])));

    $this->logger->addInfo("Attendance Report fetch by student: " . $email);
    $data = $entityManager->getRepository('Student')->getStudentByEmail($email);
    if ($data != false) {

        //get session

        require_once __DIR__ . '/../utility.php';
        $fn = new Session();
        $current_session = $fn->getCurrentSession();

        $data1 = $entityManager->getRepository('Attendance')->fetchReportByRollSubjectWise($email, $data, $current_session);
        return $response->withJson($data1, 200);
    } else {
        return $response->withJson(false, 200);
    }

});
