<?php
use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;

$app->post('/{apikey}/addfeedbackcategory', function(Request $request, Response $response, $args){
    

    require __DIR__ . '/../../bootstrap.php';
    if(getenv('ADMIN_API_KEY')==$args['apikey']){
    $body = $request->getParsedBody();
            
    $data= $entityManager->getRepository('FeedbackCategory')->addFeedbackCategory($body);

    return $response->withJson($data, 200);
    }
    else return $response->withStatus(401);
});

$app->get('/getfeedbackcategory', function(Request $request, Response $response, $args){
    

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();
            
    $data= $entityManager->getRepository('FeedbackCategory')->getFeedbackCategory();

    return $response->withJson($data, 200);
});



$app->get('/{id}/getfeedbackcategorysingle', function(Request $request, Response $response, $args){
    

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();
            
    $data = $entityManager->getRepository('FeedbackCategory')->getFeedbackCategory($args['id']);

    return $response->withJson($data, 200);
});

$app->put('/{apikey}/{id}/updatefeedbackcategory', function(Request $request, Response $response, $args){
    

    require __DIR__ . '/../../bootstrap.php';
   if(getenv('ADMIN_API_KEY')==$args['apikey']){
    $body = $request->getParsedBody();
            
    $data = $entityManager->getRepository('FeedbackCategory')->updateFeedbackCategory($args['id'],$body);

    return $response->withJson($data, 200);
   }
   else return $response->withStatus(401);
});

$app->delete('/{apikey}/{id}/deletefeedbackcategory', function(Request $request, Response $response, $args){
    

    require __DIR__ . '/../../bootstrap.php';
    if(getenv('ADMIN_API_KEY')==$args['apikey']){
   
    $data = $entityManager->getRepository('FeedbackCategory')->deleteFeedbackCategory($args['id']);

    return $response->withJson($data, 200);
    }
    else return $response->withStatus(401);
});