<?php
use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;

$app->post('/{apikey}/addfeedbackquestion', function(Request $request, Response $response, $args){
    

    require __DIR__ . '/../../bootstrap.php';
    if(getenv('ADMIN_API_KEY')==$args['apikey']){
    $body = $request->getParsedBody();
            
    $data= $entityManager->getRepository('FeedbackQuestion')->addFeedbackQuestion($body);

    return $response->withJson($data, 200);
    }
    else return $response->withStatus(401);
});

$app->get('/getfeedbackquestion', function(Request $request, Response $response, $args){
    

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();
            
    $data= $entityManager->getRepository('FeedbackQuestion')->getFeedbackQuestion();

    return $response->withJson($data, 200);
});



$app->get('/{id}/getfeedbackquestionsingle', function(Request $request, Response $response, $args){
    

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();
            
    $data = $entityManager->getRepository('FeedbackQuestion')->geFeedbackQuestionSingle($args['id']);

    return $response->withJson($data, 200);
});

$app->put('/{apikey}/{id}/updatefeedbackquestion', function(Request $request, Response $response, $args){
    

    require __DIR__ . '/../../bootstrap.php';
   if(getenv('ADMIN_API_KEY')==$args['apikey']){
    $body = $request->getParsedBody();
            
    $data = $entityManager->getRepository('FeedbackQuestion')->updateFeedbackQuestion($args['id'],$body);

    return $response->withJson($data, 200);
   }
   else return $response->withStatus(401);
});

$app->delete('/{apikey}/{id}/deletefeedbackquestion', function(Request $request, Response $response, $args){
    

    require __DIR__ . '/../../bootstrap.php';
    if(getenv('ADMIN_API_KEY')==$args['apikey']){
   
    $data = $entityManager->getRepository('FeedbackQuestion')->deleteFeedbackQuestion($args['id']);

    return $response->withJson($data, 200);
    }
    else return $response->withStatus(401);
});