<?php
use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;

$app->post('/{apikey}/addfeedbacksession', function(Request $request, Response $response, $args){
    

    require __DIR__ . '/../../bootstrap.php';
    if(getenv('ADMIN_API_KEY')==$args['apikey']){
    $body = $request->getParsedBody();
            
    $data= $entityManager->getRepository('FeedbackSession')->addFeedbackSession($body);

    return $response->withJson($data, 200);
    }
    else return $response->withStatus(401);
});

$app->get('/getfeedbacksession', function(Request $request, Response $response, $args){
    

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();
            
    $data= $entityManager->getRepository('FeedbackSession')->getFeedbackSession();

    return $response->withJson($data, 200);
});

$app->get('/getactivefeedbacksession', function(Request $request, Response $response, $args){
    

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();
            
    $data= $entityManager->getRepository('FeedbackSession')->getActiveFeedbackSession();

    return $response->withJson($data, 200);
});

$app->get('/{id}/getfeedbacksessionsingle', function(Request $request, Response $response, $args){
    

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();
            
    $data = $entityManager->getRepository('FeedbackSession')->getFeedbackSessionSingle($args['id']);

    return $response->withJson($data, 200);
});

$app->put('/{apikey}/{id}/updatefeedbacksession', function(Request $request, Response $response, $args){
    

    require __DIR__ . '/../../bootstrap.php';
   if(getenv('ADMIN_API_KEY')==$args['apikey']){
    $body = $request->getParsedBody();
            
    $data = $entityManager->getRepository('FeedbackSession')->updateFeedbackSession($args['id'],$body);

    return $response->withJson($data, 200);
   }
   else return $response->withStatus(401);
});

$app->delete('/{apikey}/{id}/deletefeedbacksession', function(Request $request, Response $response, $args){
    

    require __DIR__ . '/../../bootstrap.php';
    if(getenv('ADMIN_API_KEY')==$args['apikey']){
    
            
    $data = $entityManager->getRepository('FeedbackSession')->deleteFeedbackSession($args['id']);

    return $response->withJson($data, 200);
    }
    else return $response->withStatus(401);
});