<?php
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;

$app->post('/{apikey}/{username}/addfeedbacks', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

        $body = $request->getParsedBody();

        $this->logger->addInfo("Feedback Submission by : " . $body['email']);


        $data = $entityManager->getRepository('Feedbacks')->addFeedbacks($body);

        return $response->withJson($data, 200);

});

$app->get('/getfeedbacks', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    $this->logger->addInfo("Fetching feedbacks");


    $data = $entityManager->getRepository('Feedbacks')->getFeedbacks();

    return $response->withJson($data, 200);
});

$app->get('/{id}/getfeedbacksingle', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    $data = $entityManager->getRepository('Feedbacks')->getFeedbackSingle($args['id']);

    return $response->withJson($data, 200);
});

$app->put('/{apikey}/{id}/updatefeedbacks', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';
    if (getenv('ADMIN_API_KEY') == $args['apikey']) {
        $body = $request->getParsedBody();

        $data = $entityManager->getRepository('Feedbacks')->updateFeedbacks($args['id'], $body);

        return $response->withJson($data, 200);
    } else {
        return $response->withStatus(401);
    }

});

$app->delete('/{apikey}/{id}/deletefeedback', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';
    if (getenv('ADMIN_API_KEY') == $args['apikey']) {

        $data = $entityManager->getRepository('Feedbacks')->deleteFeedback($args['id']);

        return $response->withJson($data, 200);
    } else {
        return $response->withStatus(401);
    }

});



$app->get('/{apikey}/getfeedbackreportcount', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';
    if (getenv('ADMIN_API_KEY') == $args['apikey']) {

        $data = $entityManager->getRepository('Feedbacks')->getFeedbackCount();

        return $response->withJson($data, 200);
    } else {
        return $response->withStatus(401);
    }

});
