<?php
use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;


$app->post('/generaluser/login', function(Request $request, Response $response, $args){
    
    require __DIR__ . '/../../bootstrap.php';
    

    $body = $request->getParsedBody();

    $headers = $request->getHeaders();
    $unit = $headers['HTTP_UNIT'];

    $this->logger->addInfo("General Login :".$unit[0]." call: " . $body['email']);
    
    $c = $this->get('env_values');
            
    $data= $entityManager->getRepository('GeneralUser')->login($unit[0],$body, $c);

    $this->logger->addInfo("General Login :" . $unit[0] . " call: " . $body['email'] . " successfull");


    return $response->withJson($data, 200);
});




$app->post('/generaluser/change_password/', function(Request $request, Response $response, $args){
    
    require __DIR__ . '/../../bootstrap.php';
    require_once __DIR__ . '/../models/User.php';

    $body = $request->getParsedBody();
          
    $data= $entityManager->getRepository('User')->checkUsername($body);

    return $response->withJson($data, 200);
});

$app->post('/generaluser/change_password_mail/', function(Request $request, Response $response, $args){
    
    require __DIR__ . '/../../bootstrap.php';
    require_once __DIR__ . '/../models/User.php';
    require_once __DIR__ . '/../functions/sendmail.php';

    $body = $request->getParsedBody();
    
    $sendmail = new SendMail();        
    $data= $sendmail->sendMail();

    return $response->withJson($data, 200);
});



$app->post('/{username}/changepassword', function(Request $request, Response $response, $args){
    

    require __DIR__ . '/../../bootstrap.php';
    require_once __DIR__ . '/../models/GeneralUser.php';

    $body = $request->getParsedBody();

    $this->logger->addInfo("Change Password request: " . $args['username']);

            
    $data= $entityManager->getRepository('GeneralUser')->changePassword($args['username'], $body);

    return $response->withJson($data, 200);
});


$app->post('/{apikey}/forcechagepassword', function(Request $request, Response $response, $args){
    

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    $this->logger->addInfo("Force Password Change request: " . $body['email']);

            
    $data= $entityManager->getRepository('GeneralUser')->forceChangePassword($body);

    return $response->withJson($data, 200);
});



$app->post('/forgotpassword', function(Request $request, Response $response, $args){
    

    require __DIR__ . '/../../bootstrap.php';
    require_once __DIR__ . '/../models/GeneralUser.php';

    $body = $request->getParsedBody();
            
    $data= $entityManager->getRepository('GeneralUser')->forgotPassword($body);

    return $response->withJson($data, 200);
});


$app->post('/forgotpassword/otp', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';
    require_once __DIR__ . '/../models/GeneralUser.php';

    $body = $request->getParsedBody();

    $data = $entityManager->getRepository('GeneralUser')->forgotPasswordOtp($body);

    return $response->withJson($data, 200);
});

$app->post('/forgotpassword/final', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';
    require_once __DIR__ . '/../models/GeneralUser.php';

    $body = $request->getParsedBody();

    $this->logger->addInfo("Password changed: " . $body['email']);


    $data = $entityManager->getRepository('GeneralUser')->forgotPasswordFinal($body);

    return $response->withJson($data, 200);
});

