<?php

use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;

$app->get('/{email}/getmyrealstudentid', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $email = addslashes(strip_tags(trim($args['email'])));


    $data = $entityManager->getRepository('Student')->findOneByEmail($email);

    return $response->withJson($data->getId(), 200);
});

$app->get('/getmyowndetails', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $token = $request->getAttribute("token");
    $student_id = $token['sub']->id;


    $data = $entityManager->getRepository('Student')->getDetailsById($student_id);

    return $response->withJson($data, 200);
});


$app->post('/getsmallupdatedprofile', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';
    
    $body = $request->getParsedBody();
    

    $data = $entityManager->getRepository('Student')->getSmallUploadedDetails($body);
    
    return $response->withJson($data, 200);
});

$app->post('/updatemysubjects', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';
    
    $body = $request->getParsedBody();
    

    $data = $entityManager->getRepository('Student')->updateSmallSubject($body);
    
    return $response->withJson($data, 200);
});

$app->post('/updatenewsubjects', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';
    
    $body = $request->getParsedBody();
    

    $data = $entityManager->getRepository('Student')->updateSmallSubject($body);
    
    return $response->withJson($data, 200);
});


$app->post('/updatemysmallprofile', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';
    
    $body = $request->getParsedBody();
    

    $data = $entityManager->getRepository('Student')->updateSmallDetails($body);
    
    return $response->withJson($data, 200);
});


$app->post('/updatemysmallprofilephoto', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';
    
    $body = $request->getParsedBody();
    

    $data = $entityManager->getRepository('Student')->updateSmallProfilePhoto($body);
    
    return $response->withJson($data, 200);
});




$app->post('/getsmallupdatedprofilephoto', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';
    
    $body = $request->getParsedBody();
    

    $data = $entityManager->getRepository('Student')->getSmallUploadedPhoto($body);
    
    return $response->withJson($data, 200);
});

$app->get('/getcourse', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $data = $entityManager->getRepository('Course')->getCourse();

    return $response->withJson($data, 200);
});


$app->get('/getcertificatetype', function (Request $request, Response $response, array $args) {

    //$this->logger->addInfo("New document creation");
    require __DIR__ . '/../../bootstrap.php';

    $data = $entityManager->getRepository('CertificateType')->getCertificateType();

    return $response->withJson($data, 200);
});

$app->post('/addcertificaterequest', function (Request $request, Response $response, array $args) {

    //$this->logger->addInfo("New document creation");
    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    $data = $entityManager->getRepository('CertificateRequest')->addCertificateRequest($body);

    return $response->withJson($data, 200);
});

$app->get('/{student_id}/getcertificaterequestbystudent', function (Request $request, Response $response, array $args) {

    //$this->logger->addInfo("New document creation");
    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    $student_id = addslashes(strip_tags(trim($args['student_id'])));

    $data = $entityManager->getRepository('CertificateRequest')->getCertificateRequestsByStudent($student_id);

    return $response->withJson($data, 200);
});
$app->get('/{apikey}/{username}/getstudentprofile', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';
    //$this->logger->addInfo("Student Profile get : " . $args['username']);

    $email = addslashes(strip_tags(trim($args['username'])));

    $data = $entityManager->getRepository('Student')->getStudentProfileSingle($email);

    return $response->withJson($data, 200);
});



$app->post('/findstudentdatalist', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';


    $body = $request->getParsedBody();
    $email = addslashes(strip_tags(trim($body['email'])));

    $data = $entityManager->getRepository('Student')->findStudentWithEmail($email);

    return $response->withJson($data, 200);
});