<?php

use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;

$app->get('/{apikey}/{username}/getcategorystudent', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';
    $email = addslashes(strip_tags(trim($args['username'])));
    $this->logger->addInfo("Category fetch by student : " . $email);

    $data = $entityManager->getRepository('FeedbackCategory')->getFeedbackCategoryForStudent($email);
    return $response->withJson($data, 200);
});

$app->get('/{apikey}/{username}/getfilledcategory', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';
    $email = addslashes(strip_tags(trim($args['username'])));
    $data = $entityManager->getRepository('FeedbackCategory')->getFeedbackCategoryForStudentFilled($email);
    return $response->withJson($data, 200);
});

$app->get('/{apikey}/{id}/getcategoryquestions', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $id = addslashes(strip_tags(trim($args['id'])));
    $data = $entityManager->getRepository('FeedbackQuestion')->getFeedbackQuestionByCategory($id);
    return $response->withJson($data, 200);
});

$app->get('/{apikey}/{username}/{id}/getcategoryteacher', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $id = addslashes(strip_tags(trim($args['id'])));
    $email = addslashes(strip_tags(trim($args['username'])));
    $this->logger->addInfo("Teacher fetch by student : " . $email);

    $data = $entityManager->getRepository('FeedbackCategory')->isNeededTeacherList($id);
    if ($data === 1) {

        $token = $request->getAttribute("token");
        $student_id = $token['sub']->id;

        $subjects = $entityManager->getRepository('Student')->getStudentSubjectsOnly($student_id);

        $fn = new Session();
        $current_session = $fn->getCurrentSession();

        $data2 = $entityManager->getRepository('Attendance')->getEmployeeBySubject($student_id, $subjects, $current_session);

        return $response->withJson($data2, 200);
    } else if ($data == 2) {

        $data2 = $entityManager->getRepository('Employee')->getLibraryEmployee();

        return $response->withJson($data2, 200);
    } else {
        $data2 = false;
        return $response->withJson($data2, 200);
    }
});

$app->get('/{apikey}/{username}/getfeedbackpercentage', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $email = addslashes(strip_tags(trim($args['username'])));
    $data = $entityManager->getRepository('Feedbacks')->getFeedbackPercentage($email);
    return $response->withJson($data, 200);
});

$app->get('/{apikey}/{username}/canstudentsubmitattendance', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $email = addslashes(strip_tags(trim($args['username'])));

    $can_submit = true;  // make it true to allow all students


    // uncomment this following line to allow all students to submit feedback
    return $response->withJson($can_submit, 200);

    $data = $entityManager->getRepository('Student')->getStudentByEmail($email);
    if ($data != false) {

        require_once __DIR__ . '/../utility.php';
        $fn = new Session();
        $current_session = $fn->getCurrentSession();

        $data1 = $entityManager->getRepository('Attendance')->fetchReportByRollSubjectWise($email, $data, $current_session);

        $att = $data1['table_data'];
        $total_count = 0;
        $attended_count = 0;
        foreach ($att as $d) {
            if ($d['total_count'] != 0) {
                $total_count = $total_count + $d['total_count'];

                $attended_count = $attended_count + $d['total_attended'];
            }
        }

        $per = 0;
        if ($total_count != 0) {
            $per = ($attended_count / $total_count) * 100;
        }

        $permissible_percentage = 50;

        if ((float) $per >= $permissible_percentage) {
            $can_submit = true;
        } else {
            $can_submit = false;
        }
    }

    return $response->withJson($can_submit, 200);
});

$app->get('/{apikey}/{username}/getcategoryteacher', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';
    $email = addslashes(strip_tags(trim($args['username'])));
    $data = $entityManager->getRepository('FeedbackCategory')->getFeedbackCategoryForTeacher($email);
    return $response->withJson($data, 200);
});
