<?php
use \Psr\Http\Message\ResponseInterface as Response;
use \Psr\Http\Message\ServerRequestInterface as Request;

$app->post('/{apikey}/addsubject', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';
    if (getenv('ADMIN_API_KEY') == $args['apikey']) {
        $body = $request->getParsedBody();

        $data = $entityManager->getRepository('SubjectMaster')->addSubject($body);

        return $response->withJson($data, 200);
    } else {
        return $response->withStatus(401);
    }

});

$app->get('/getsubject', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    $data = $entityManager->getRepository('SubjectMaster')->getSubject($body);

    return $response->withJson($data, 200);
});

$app->get('/{course}/getadmissionsubject', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';
    
    $course = addslashes(strip_tags(trim($args['course'])));
    
    $data = $entityManager->getRepository('SubjectMaster')->getAdmissionSubjects($course);

    return $response->withJson($data, 200);
});

$app->get('/{course}/{stream}/getexamsubjects', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';
    
    $course = addslashes(strip_tags(trim($args['course'])));
    $stream = addslashes(strip_tags(trim($args['stream'])));

    $data = $entityManager->getRepository('SubjectMaster')->getExamSubjects($course, $stream);

    return $response->withJson($data, 200);
});


$app->get('/{course}/getadmissionsubjectmajor', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $course = addslashes(strip_tags(trim($args['course'])));

    $data = $entityManager->getRepository('SubjectMaster')->getAdmissionSubjectsMajor($course);

    return $response->withJson($data, 200);
});

$app->get('/{username}/getsubjectbydeptcode', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';
    
        $username = addslashes(strip_tags(trim($args['username'])));

        $r = $entityManager->getRepository('Employee')->getEmployeeForEdit($username);
        $dept_code = $r[0]->getDeptCode();

        $data = $entityManager->getRepository('SubjectMaster')->getSubjectByDepartment($dept_code);

        return $response->withJson($data, 200);
   

});

$app->get('/{course}/{stream}/{type}/getadmissionsubjectbytype', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    // type 1 : Major

    // type 2: Regular

    $course = addslashes(strip_tags(trim($args['course'])));
    $stream = addslashes(strip_tags(trim($args['stream'])));
    $type = addslashes(strip_tags(trim($args['type'])));

    $data = $entityManager->getRepository('SubjectMaster')->getAdmissionSubjectsByType($course, $stream, $type);

    return $response->withJson($data, 200);
});

$app->get('/{course}/{stream}/{semester}/getadmissionsubjectbysemester', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $course = addslashes(strip_tags(trim($args['course'])));
    $stream = addslashes(strip_tags(trim($args['stream'])));
    $semester = addslashes(strip_tags(trim($args['semester'])));

    if ($course == 'TDC' && $stream == 'COMMERCE' && $semester == '5') {
        $data = $entityManager->getRepository('SubjectMaster')->getAdmissionSubjectsBySemester($course, $stream, $semester);

    }else if ($course == 'TDC' && $stream == 'COMMERCE' && $semester == 3) {
        $data = $entityManager->getRepository('SubjectMaster')->getAdmissionSubjectsWithDifferentMil($course, $stream);

    } else {
        $data = $entityManager->getRepository('SubjectMaster')->getAdmissionSubjects($course, $stream);
    }

    return $response->withJson($data, 200);
});


$app->get('/{sub_code}/getsubjectsingle', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $body = $request->getParsedBody();

    $data = $entityManager->getRepository('SubjectMaster')->getSubjectSingle($args['sub_code']);

    return $response->withJson($data, 200);
});

$app->put('/{apikey}/{sub_code}/updatesubject', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';
    if (getenv('ADMIN_API_KEY') == $args['apikey']) {
        $body = $request->getParsedBody();

        $data = $entityManager->getRepository('SubjectMaster')->updateSubject($args['sub_code'], $body);

        return $response->withJson($data, 200);
    } else {
        return $response->withStatus(401);
    }

});

$app->delete('/{apikey}/{sub_code}/deletesubject', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';
    if (getenv('ADMIN_API_KEY') == $args['apikey']) {

        $data = $entityManager->getRepository('SubjectMaster')->deleteSubject($args['sub_code']);

        return $response->withJson($data, 200);
    } else {
        return $response->withStatus(401);
    }

});

$app->get('/{apikey}/getmilsubjects', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $data = $entityManager->getRepository('SubjectMaster')->getMilSubjects();

    return $response->withJson($data, 200);
});

$app->get('/{course}/getadmissionsubjectbycourse', function (Request $request, Response $response, $args) {

    require __DIR__ . '/../../bootstrap.php';

    $course = addslashes(strip_tags(trim($args['course'])));
 

    $data = $entityManager->getRepository('SubjectMaster')->getAdmissionSubjects($course);

    return $response->withJson($data, 200);
});